//
//  EBGViewController.m
//  Enbugged
//
//  Created by chat on 16.10.13.
//  Copyright (c) 2013 Chat Wacharamanotham. All rights reserved.
//

#import "EBGViewController.h"
#import "EBGData.h"

// =================================================================================================================
@interface EBGViewController ()
// =================================================================================================================
{
    NSArray *_textLines;
    NSInteger _lineIndex;
}

@property (weak, nonatomic) IBOutlet UILabel *outputLabel;
@property (copy) NSString *currentFileName;

@property (copy) EBGData *data;

@end
// =================================================================================================================







// =================================================================================================================
@implementation EBGViewController
// =================================================================================================================


- (void)viewDidLoad;
{
    [super viewDidLoad];
    
    
    // ---------------------- value vs. address
    
    EBGData *localVar = [[EBGData alloc] init];
    localVar.text = @"local data";
    
    // TODO: B1 Set a breakpoint to print the value of the local variable "localVar"
    // TODO: B2 Set a breakpoint to print the *address* of the local variable "localVar"
    
    
    // ---------------------- property vs. instance variable
    
    // TODO: B3 Set a breakpoint to print the address stored in the instance variable "_data".
    
    // TODO: Q1 We haven't define "_data" anywhere. Where does it come from?
    _data = localVar;

    // TODO: B4 Set a breakpoint to print the address stored in the instance variable "_data".
    self.data = localVar;
    
    // TODO: B5 Set a breakpoint to print the address stored in the instance variable "_data".
    
    // TODO: Q2 Explian why we have same or different the addresseses as printed in B2–B5.
    
    
    // ---------------------- equality
    BOOL isAddressEqualToLocalVar = (self.data  == localVar);
    BOOL isEqualToLocalVar = [self.data isEqual:localVar];
    
    
    // TODO: B6 Set a breakpoint here. Print out the values of the two BOOL variables above.
    // TODO: Q3 Explain why the results of the two BOOL variables above are the same/different
    
    
    
    // ---------------------- getter/setter
    
    // TODO: B7 Set a "symbolic breakpoint" to print a log meessage when [EBGViewController currentFileName] is called
    // TODO: B8 Set a "symbolic breakpoint" to print a log meessage when [EBGViewController setCurrentFileName:] is called
    
    _currentFileName = @"Omelet";
    self.currentFileName = @"Omelet";
    
    
    BOOL ivarComparison = (_currentFileName == @"Omelet");
    BOOL propertyComparison = (self.currentFileName == @"Omelet");
    
    // In the two lines above, we accessed the instance variable "_currentFileName".
    // TODO: Q4 Why were the breakpoint B7 and B8 called only once?
    
    
    
    _currentFileName = @"Hamlet";
    _textLines = [self loadText:_currentFileName];
    self.outputLabel.text = [self textForLineIndex:_lineIndex];
}


// -----------------------------------------------------------------------------------------------------------------
#pragma mark -
#pragma mark event handling
// -----------------------------------------------------------------------------------------------------------------

- (IBAction)onClickPreviousButton:(id)sender;
{
    // TODO: B9 Set a breakpoint here to call method [self debuggerCall]; only when this breakpoint has been passed more than 5 times
    _lineIndex = MAX(0, _lineIndex - 1);
    self.outputLabel.text = [self textForLineIndex:_lineIndex];
    
}

- (IBAction)onClickNextButton:(id)sender;
{
    if (_lineIndex < [self totalNumberOfLines])
    {
        // TODO: B10 Set a breakpoint here to increase line index by one
    }
    
    self.outputLabel.text = [self textForLineIndex:_lineIndex];
    
}

- (IBAction)onClickSwitchTextButton:(id)sender
{
    // TODO: B11 Set a breakpoint here to call [self switchText]
}

// -----------------------------------------------------------------------------------------------------------------
#pragma mark -
#pragma mark internal logic
// -----------------------------------------------------------------------------------------------------------------

- (NSArray *)loadText:(NSString *)theFileName;
{
    NSString *textString = [NSString stringWithContentsOfFile:[[NSBundle mainBundle] pathForResource:theFileName ofType:@"txt"]
                                                     encoding:NSUTF8StringEncoding
                                                        error:nil];
    return [textString componentsSeparatedByString:@"\n"];
}

- (NSString *)textForLineIndex:(NSInteger)theLineIndex;
{
    // TODO: B12 Set a breakpoint here to print "theLineIndex".
    
    NSString *line = [_textLines objectAtIndex:theLineIndex];
    
    // TODO: B13 Set a breakpoint here to print the text of the line *only* at line 10
    
    return line;
}

- (NSInteger)totalNumberOfLines;
{
    return [_textLines count];
}

- (void)debuggerCall;
{
    NSLog(@"After 5 times, now I'm finally called.");
}

- (void)switchText;
{
    if ([self.currentFileName isEqualToString:@"Hamlet"])
    {
        self.currentFileName = @"TheTempest";
    }
    
    else if ([self.currentFileName isEqualToString:@"TheTempest"])
    {
        self.currentFileName = @"Hamlet";
    }
    
    _textLines = [self loadText:_currentFileName];
    self.outputLabel.text = [self textForLineIndex:_lineIndex];
}

@end
